<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class FormScreenFactory
{
    public function __construct(private readonly FormFactoryInterface $formFactory, private readonly ValidatorInterface $validator)
    {
    }

    public function screen(string $formType, ?object $formData = null): FormScreen
    {
        return new FormScreen($this->formFactory->create($formType, $formData), $this->validator, $formData);
    }
}
