<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Filter\Participant;

use Doctrine\ORM\QueryBuilder;
use Ferienpass\AdminBundle\Form\Filter\AbstractFilterType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatableMessage;
use Symfony\Contracts\Translation\TranslatableInterface;

class UnpaidFilter extends AbstractFilterType
{
    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'choices' => [
                'unpaid',
            ],
            'choice_label' => function ($choice): TranslatableMessage|string {
                if ('unpaid' === $choice) {
                    return 'unbezahlt';
                }

                return new TranslatableMessage('payments.status.'.$choice, domain: 'admin');
            },
            'placeholder' => '-',
        ]);
    }

    public function apply(QueryBuilder $qb, FormInterface $form): void
    {
        if ($form->isEmpty()) {
            return;
        }

        $v = $form->getData();

        if ('unpaid' !== $v) {
            throw new \Exception('Unhandled filter value');
        }

        $qb
            ->andWhere('a.paid = 0')
            ->andWhere('a.payable = 1')
        ;
    }

    protected function getHumanReadableValue(FormInterface $form): string|TranslatableInterface|null
    {
        return new TranslatableMessage('payments.status.'.$form->getData(), domain: 'admin');
    }
}
