<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Extension\Form;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Form\Event\SubmitEvent;
use Ferienpass\AdminBundle\Service\FileUploader;
use Ferienpass\CoreBundle\Entity\DbafsAttachment;
use Ferienpass\CoreBundle\Entity\DbafsMedia;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\String\Slugger\SluggerInterface;

class EditOfferType extends AbstractTypeExtension implements FormTypeEventSubscriber
{
    public function __construct(private readonly FileUploader $fileUploader, private readonly VirtualFilesystemInterface $mediaStorage, private readonly VirtualFilesystemInterface $attachmentsStorage, private readonly EntityManagerInterface $entityManager, private readonly SluggerInterface $slugger)
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            SubmitEvent::class => 'submit',
        ];
    }

    public function submit(SubmitEvent $event): void
    {
        $form = $event->getForm();
        $entity = $event->getData();
        if (!$entity instanceof OfferInterface) {
            return;
        }

        $this->entityManager->persist($entity);

        $entity->generateAlias($this->slugger);

        if ($form->has('uploadMedia') && $uploadedFile = $form->get('uploadMedia')->getData()) {
            $uuid = $this->fileUploader->upload($this->mediaStorage, $uploadedFile);

            $entity->addMedia($this->entityManager->getReference(DbafsMedia::class, $uuid));
        }

        if ($form->has('uploadAgreeLetter') && $uploadedFile = $form->get('uploadAgreeLetter')->getData()) {
            $uuid = $this->fileUploader->upload($this->attachmentsStorage, $uploadedFile);

            $entity->setAgreementLetter($this->entityManager->getReference(DbafsAttachment::class, $uuid));
        }

        if ($form->has('uploadAttachment') && $uploadedFile = $form->get('uploadAttachment')->getData()) {
            $uuid = $this->fileUploader->upload($this->attachmentsStorage, $uploadedFile);

            $entity->addAttachment($this->entityManager->getReference(DbafsAttachment::class, $uuid));
        }
    }

    public static function getExtendedTypes(): iterable
    {
        return [\Ferienpass\AdminBundle\Form\EditOfferType::class];
    }
}
