<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Extension\Form;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Form\Event\SubmitEvent;
use Ferienpass\AdminBundle\Service\FileUploader;
use Ferienpass\CoreBundle\Entity\DbafsLogo;
use Ferienpass\CoreBundle\Entity\Host;
use Symfony\Component\Form\AbstractTypeExtension;

class EditHostType extends AbstractTypeExtension implements FormTypeEventSubscriber
{
    public function __construct(private readonly FileUploader $fileUploader, private readonly EntityManagerInterface $entityManager, private readonly VirtualFilesystemInterface $logosStorage)
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            SubmitEvent::class => 'submit',
        ];
    }

    public function submit(SubmitEvent $event): void
    {
        $form = $event->getForm();
        $host = $event->getData();

        if (!$host instanceof Host) {
            return;
        }

        $this->entityManager->persist($host);

        if ($form->has('logo') && ($imageFile = $form->get('logo')->getData())) {
            $uuid = $this->fileUploader->upload($this->logosStorage, $imageFile);
            $host->setLogo($this->entityManager->getReference(DbafsLogo::class, $uuid));
        }
    }

    public static function getExtendedTypes(): iterable
    {
        return [\Ferienpass\AdminBundle\Form\EditHostType::class];
    }
}
