<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\Extension\Form;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Form\Event\SubmitEvent;
use Ferienpass\CoreBundle\Entity\Edition;
use Symfony\Component\Form\AbstractTypeExtension;

class EditEditionType extends AbstractTypeExtension implements FormTypeEventSubscriber
{
    public function __construct(private readonly EntityManagerInterface $entityManager)
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            SubmitEvent::class => 'submit',
        ];
    }

    public function submit(SubmitEvent $event): void
    {
        $entity = $event->getData();

        if (!$entity instanceof Edition) {
            return;
        }

        $this->entityManager->persist($entity);
    }

    public static function getExtendedTypes(): iterable
    {
        return [\Ferienpass\AdminBundle\Form\EditEditionType::class];
    }
}
