<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Ferienpass\AdminBundle\Form\CompoundType\PostalAddressesType;
use Ferienpass\CoreBundle\Entity\Host;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;
use Symfony\UX\Dropzone\Form\DropzoneType;

class EditHostType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Host::class,
            'label_format' => 'hosts.label.%name%',
            'translation_domain' => 'admin',
            'required' => false,
        ]);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', null, ['section' => 'default', 'width' => '2/3'])
            ->add('phone', null, ['section' => 'contact', 'width' => '1/2'])
            ->add('fax', null, ['section' => 'contact', 'width' => '1/2'])
            ->add('mobile', null, ['section' => 'contact', 'width' => '1/2'])
            ->add('email', EmailType::class, ['section' => 'contact', 'width' => '1/2|clr'])
            ->add('website', UrlType::class, ['section' => 'contact', 'width' => '1/2'])
            ->add('postalAddresses', PostalAddressesType::class, ['section' => 'address'])
            ->add('text', TextareaType::class, ['attr' => ['rows' => 4], 'section' => 'default'])
            ->add('logo', DropzoneType::class, [
                'section' => 'media',
                'attr' => ['placeholder' => 'offers.dropzonePlaceholder'],
                'mapped' => false,
                'constraints' => [
                    new File(maxSize: '1024k', mimeTypes: [
                        'image/jpeg',
                        'image/png',
                        'image/svg+xml',
                    ], mimeTypesMessage: 'Erlaubte Dateitypen sind: JPG, PNG, SVG'),
                ],
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'Daten speichern',
            ])
        ;
    }
}
