<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Ferienpass\AdminBundle\Form\CompoundType\ConsentFormType;
use Ferienpass\AdminBundle\Form\CompoundType\EditionTasksType;
use Ferienpass\AdminBundle\WorkflowSurvey\OfferCompleteSurveyInterface;
use Ferienpass\CoreBundle\Entity\Edition;
use Ferienpass\CoreBundle\Entity\Host;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\DependencyInjection\Attribute\AutowireIterator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

class EditEditionType extends AbstractType
{
    private readonly array $surveys;

    public function __construct(#[AutowireIterator(OfferCompleteSurveyInterface::class, defaultIndexMethod: 'getName')] $surveys)
    {
        $this->surveys = iterator_to_array($surveys);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Edition::class,
            'label_format' => 'editions.label.%name%',
            'translation_domain' => 'admin',
            'required' => false,
        ]);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', null, ['section' => 'default', 'width' => '1/2'])
            ->add('alias', null, ['section' => 'default', 'width' => '1/2', 'help' => 'editions.help.alias'])
            ->add('tasks', EditionTasksType::class, ['section' => 'tasks', 'label' => false])
            ->add('hasAgreementLetter', CheckboxType::class, ['section' => 'agreementLetter', 'help' => 'editions.help.hasAgreementLetter'])
            ->add('agreementLetterText', TextareaType::class, ['section' => 'agreementLetter', 'help' => 'editions.help.hasAgreementLetter'])
            ->add('consentForms', LiveCollectionType::class, [
                'section' => 'agreementLetter',
                'entry_type' => ConsentFormType::class,
                'label' => false,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ])
            ->add('hosts', EntityType::class, [
                'section' => 'hosts',
                'class' => Host::class,
                'choice_label' => 'name',
                'multiple' => true,
                'expanded' => false,
                'help' => 'editions.help.hosts',
                'autocomplete' => true,
            ])
            ->add('hostsCanAssign', CheckboxType::class, ['section' => 'hosts', 'help' => 'editions.help.hostsCanAssign'])
            ->add('surveyWithApplication', ChoiceType::class, [
                'choices' => array_keys($this->surveys),
                'choice_label' => fn ($choice) => $choice,
                'placeholder' => '-',
                'section' => 'workflow',
                'help' => 'editions.help.surveyWithApplication',
            ])
            ->add('surveyWithoutApplication', ChoiceType::class, [
                'choices' => array_keys($this->surveys),
                'choice_label' => fn ($choice) => $choice,
                'placeholder' => '-',
                'section' => 'workflow',
                'help' => 'editions.help.surveyWithApplication',
            ])
            ->add('payments', ChoiceType::class, [
                // 'choices' => ['on-site'],
                'choice_label' => fn ($choice) => $choice,
                'placeholder' => 'Standard-Einstellung',
                'required' => false,
                'section' => 'payment',
                'help' => 'editions.help.payments',
            ])
            ->add('archived', CheckboxType::class, ['section' => 'archived', 'help' => 'editions.help.archived'])
            ->add('submit', SubmitType::class, [
                'label' => 'Daten speichern',
            ])
        ;
    }
}
