<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\CompoundType;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Ferienpass\CoreBundle\Entity\OfferAttachment;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class OfferAttachmentType extends AbstractType
{
    public function __construct(private readonly VirtualFilesystemInterface $attachmentsStorage)
    {
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event): void {
            $form = $event->getForm();
            $data = $event->getData();

            if (!$data instanceof OfferAttachment) {
                return;
            }

            $form
                ->add('file', HiddenType::class, [
                    'label' => false,
                    'data' => (string) $this->attachmentsStorage->generatePublicUri($data->getAttachment()->getUuid()),
                    'mapped' => false,
                ])
            ;

            //                ->add('alt', TextType::class, [
            //                    'help' => 'Hier geben Sie an, was auf dem Bild zu sehen ist (Barrierefreiheit)',
            //                    'property_path' => 'media.alt',
            //                ])
            //                ->add('creator', TextType::class, [
            //                    'required' => true,
            //                    'help' => 'Hier geben Sie den Namen des/der Fotograf:in oder den Namen des/der Ersteller:in des Kunstwerkes (Urheberrecht)',
            //                    'property_path' => 'media.creator',
            //                ])
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => OfferAttachment::class,
        ]);
    }
}
