<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form\CompoundType;

use Ferienpass\AdminBundle\Form\Type\MarkdownType;
use Ferienpass\CoreBundle\Entity\ConsentForm;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ConsentFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('text', MarkdownType::class, [
                'help' => 'consentForm.textHelp',
                'property_path' => 'text',
            ])
            ->add('subject', ChoiceType::class, [
                'choices' => [
                    'account',
                    'participant',
                ],
                'choice_label' => fn ($choice, string $key, mixed $value): string => 'consentForm.subject.'.$choice,
                'expanded' => true,
                'help' => 'consentForm.subjectHelp',
                'property_path' => 'subject',
                'empty_data' => 'participant',
            ])
            ->add('compulsory', ChoiceType::class, [
                'choices' => [
                    'compulsory',
                    'opt-in',
                    'opt-out',
                    'force_decision',
                ],
                'choice_label' => fn ($choice, string $key, mixed $value): string => 'consentForm.compulsory.'.$choice,
                'expanded' => true,
                'help' => 'consentForm.compulsoryHelp',
                'property_path' => 'compulsory',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'label_format' => 'consentForm.%name%',
            'class' => ConsentForm::class,
            'empty_data' => new ConsentForm(),
        ]);
    }
}
