<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\NotCompromisedPassword;

class AcceptInvitationType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        if ($options['create_user']) {
            $builder
                ->add('firstname', TextType::class)
                ->add('lastname', TextType::class)
                ->add('email', EmailType::class, [
                    'attr' => [
                        'placeholder' => 'email@beispiel.de',
                    ],
                ])
                ->add('plainPassword', PasswordType::class, [
                    'label' => 'login.password',
                    'help' => 'Ihr Passwort muss aus mindestens 8 Zeichen bestehen.',
                    'constraints' => [
                        new NotBlank(),
                        new NotCompromisedPassword(),
                        new Length(min: 8),
                    ],
                ])
            ;
        }

        $builder
            ->add('submit', SubmitType::class, [
                'label' => 'Einladung akzeptieren',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefined('create_user');

        $resolver->setDefaults([
            'create_user' => false,
            'translation_domain' => 'admin',
            'label_format' => 'user.label.%name%',
        ]);
    }
}
