<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle;

use Ferienpass\AdminBundle\DependencyInjection\Compiler\FormEventSubscriberPass;
use Ferienpass\AdminBundle\DependencyInjection\Compiler\FormTypeGuesserPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class FerienpassAdminBundle extends Bundle
{
    public function getPath(): string
    {
        return \dirname(__DIR__);
    }

    public function build(ContainerBuilder $container): void
    {
        $container->addCompilerPass(new FormEventSubscriberPass());
        $container->addCompilerPass(new FormTypeGuesserPass(), priority: 10);
    }
}
