<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\EventListener;

use Ferienpass\AdminBundle\Event\ParticipantListEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;

#[AsEventListener(priority: -10)]
class ParticipantListListener
{
    public function __invoke(ParticipantListEvent $event): void
    {
        $columns = $event->getColumns();

        foreach ($event->getOffer()->getApplicationExtra() ?? [] as $extra) {
            if ('yn' === $extra['type']) {
                $columns[$extra['question']] = "{{ 'y' == item.extra('{$extra['uuid']}') ? 'Ja' : 'Nein' }}";
            } else {
                $columns[$extra['question']] = "{{ item.extra('{$extra['uuid']}') }}";
            }
        }

        $event->setColumns($columns);
    }
}
