<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Event;

use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Contracts\EventDispatcher\Event;

class ParticipantListEvent extends Event
{
    public function __construct(private readonly OfferInterface $offer, private array $columns)
    {
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getColumns(): array
    {
        return $this->columns;
    }

    public function setColumns(array $columns): void
    {
        $this->columns = $columns;
    }
}
