<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Dto;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;

class AddAttendanceDto
{
    public function __construct(public ?ParticipantInterface $participant = null, public ?OfferInterface $offer = null, public string $status = Attendance::STATUS_WAITING, public bool $notify = false, public bool $commit = true)
    {
    }

    public function getOffer(): ?OfferInterface
    {
        return $this->offer;
    }

    public function getParticipant(): ?ParticipantInterface
    {
        return $this->participant;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function shallNotify(): bool
    {
        return $this->notify;
    }

    public function shallCommit(): bool
    {
        return $this->commit;
    }
}
