<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('ferienpass_admin');
        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('participant_list')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('hosts_can_add')->defaultTrue()->end()
                        ->scalarNode('hosts_can_edit')->defaultTrue()->end()
                    ->end()
                ->end() // participant_list
                ->scalarNode('privacy_consent_text')->defaultNull()->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
