<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\DependencyInjection\Compiler;

use Ferienpass\AdminBundle\Form\Extension\Form\FormTypeEventSubscriber;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class FormEventSubscriberPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        foreach ($container->getDefinitions() as $definition) {
            if (!$definition->isAutoconfigured() || !$class = $definition->getClass()) {
                continue;
            }

            if (!class_exists($class)) {
                continue;
            }

            if (!is_subclass_of($class, FormTypeEventSubscriber::class)) {
                continue;
            }

            $definition->clearTag('kernel.event_subscriber');
        }
    }
}
