<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Controller\Page;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Form\FormScreenFactory;
use Ferienpass\AdminBundle\Form\HandleFormTrait;
use Ferienpass\AdminBundle\Form\PersonalDataType;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\CurrentUser;

#[Route('/persönliche-daten/{section?personal}', name: 'admin_user_index')]
final class PersonalDataController extends AbstractController
{
    use HandleFormTrait;

    public function __invoke(#[CurrentUser] User $user, string $section, Request $request, EventDispatcherInterface $dispatcher, EntityManagerInterface $entityManager, FormScreenFactory $forms): Response
    {
        $form = $this->createForm(PersonalDataType::class, $user, $formOptions = [
            'display_section' => $section,
        ]);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $this->handleSubmit($form, $dispatcher, $request);

            $entityManager->flush();

            return $this->redirectToRoute('admin_user_index', ['section' => $section]);
        }

        return $this->render('@FerienpassAdmin/page/user/index.html.twig', [
            'item' => $user,
            'form' => $form,
            'section' => $section,
            'formOptions' => $formOptions,
            'formScreen' => $forms->screen(PersonalDataType::class, $user),
            'headline' => 'user.title',
        ]);
    }
}
