<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Controller\Page;

use Ferienpass\AdminBundle\Breadcrumb\Breadcrumb;
use Ferienpass\CoreBundle\Entity\Edition;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Export\Offer\OffersExportInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\TaggedLocator;
use Symfony\Component\DependencyInjection\ServiceLocator;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\CurrentUser;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted('ROLE_ADMIN')]
class OffersReviewController extends AbstractController
{
    #[Route('/angebote/{alias}/freigeben', name: 'admin_offers_review')]
    public function __invoke(?Edition $edition, #[CurrentUser] User $user, Request $request, Breadcrumb $breadcrumb, MessageBusInterface $bus, #[TaggedLocator(OffersExportInterface::class, indexAttribute: 'name', defaultIndexMethod: 'getName')] ServiceLocator $exporters): Response
    {
        /** @noinspection FormViewTemplate `createView()` messes ups error handling/redirect */
        return $this->render('@FerienpassAdmin/page/offers/reviewAll.html.twig', [
            'edition' => $edition,
            'pdfs' => array_map(fn ($v) => substr($v, 0, -4), array_filter(array_keys($exporters->getProvidedServices()), fn (string $k) => str_ends_with($k, '.pdf'))),
            'breadcrumb' => $breadcrumb->generate(['offers.title', ['route' => 'admin_offers_index']], [$edition?->getName() ?? '', ['route' => 'admin_offers_index', 'routeParameters' => ['edition' => $edition?->getAlias()]]], 'Korrekturabzüge'),
        ]);
    }
}
