<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Controller\Page;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Breadcrumb\Breadcrumb;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted('ROLE_ADMIN')]
final class FilesController extends AbstractController
{
    public const array STORAGES = [
        'Bilder & Medien' => 'media',
        'Logos' => 'logos',
        'Anhänge & Downloads' => 'attachments',
    ];

    public static function getSubscribedServices(): array
    {
        $services = parent::getSubscribedServices();

        foreach (self::STORAGES as $storage) {
            $services["contao.filesystem.virtual.$storage"] = VirtualFilesystemInterface::class;
        }

        return $services;
    }

    #[Route('/dateien/{!storage}/{path?}', name: 'admin_files', requirements: ['path' => '.+'], defaults: ['storage' => 'media'])]
    public function index(string $storage, ?string $path, Breadcrumb $breadcrumb, EntityManagerInterface $em): Response
    {
        /** @noinspection MissingService */
        if (!$this->container->has("contao.filesystem.virtual.$storage")) {
            throw $this->createNotFoundException();
        }

        return $this->render('@FerienpassAdmin/page/files/index.html.twig', [
            'storage' => $storage,
            'path' => $path ?? '',
            'breadcrumb' => $breadcrumb->generate(['files.title', ['route' => 'admin_files']], 'files.title'),
        ]);
    }
}
