<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Controller\Page;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpFoundation\Response;

final class Error403Controller extends AbstractController
{
    public function __construct(#[Autowire(env: 'ADMIN_EMAIL')] private readonly string $adminEmail)
    {
    }

    public function __invoke(): Response
    {
        return $this->render('@FerienpassAdmin/page/error/403.html.twig', [
            'adminEmail' => $this->adminEmail,
        ]);
    }
}
