<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Controller\Page;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Breadcrumb\Breadcrumb;
use Ferienpass\AdminBundle\Form\EditEditionType;
use Ferienpass\AdminBundle\Form\FormScreenFactory;
use Ferienpass\AdminBundle\Form\HandleFormTrait;
use Ferienpass\CoreBundle\Entity\Edition;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted('ROLE_ADMIN')]
#[Route('/saisons')]
final class EditionsEditController extends AbstractController
{
    use HandleFormTrait;

    #[Route('/neu/{section?default}', name: 'admin_editions_create')]
    #[Route('/{alias}/{section?default}', name: 'admin_editions_edit')]
    public function edit(?Edition $edition, string $section, Request $request, EntityManagerInterface $entityManager, EventDispatcherInterface $dispatcher, Breadcrumb $breadcrumb, FormScreenFactory $forms): Response
    {
        $edition ??= new Edition();

        $form = $this->createForm(EditEditionType::class, $edition, $formOptions = [
            'display_section' => $section,
        ]);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $this->handleSubmit($form, $dispatcher, $request);

            $entityManager->flush();

            return $this->redirectToRoute('admin_editions_edit', ['alias' => $edition->getAlias(), 'section' => $section]);
        }

        $breadcrumbTitle = $edition ? $edition->getName().' (bearbeiten)' : 'editions.new';

        return $this->render('@FerienpassAdmin/page/edition/edit.html.twig', [
            'item' => $edition,
            'form' => $form,
            'formOptions' => $formOptions,
            'formScreen' => $forms->screen(EditEditionType::class, $edition),
            'section' => $section,
            'breadcrumb' => $breadcrumb->generate(['tools.title', ['route' => 'admin_tools']], ['editions.title', ['route' => 'admin_editions_index']], $breadcrumbTitle),
        ]);
    }
}
