<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components;

use Ferienpass\CoreBundle\Entity\MessengerLog;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\TwigComponent\Attribute\ExposeInTemplate;

#[AsLiveComponent(route: 'live_component_admin')]
class SentMessages extends AbstractController
{
    use DefaultActionTrait;

    #[LiveProp]
    public MessengerLog $log;

    #[ExposeInTemplate]
    public function notifications(): array
    {
        if ($this->log->getChildren()->isEmpty()) {
            return $this->log->getNotifications()->toArray();
        }

        $notifications = $this->log->getChildren()->map(fn (MessengerLog $l) => $l->getNotifications()->toArray())->toArray();

        return array_merge(...$notifications);
    }
}
