<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components;

use Contao\CoreBundle\Filesystem\FilesystemItem;
use Contao\CoreBundle\Filesystem\FilesystemItemIterator;
use Contao\CoreBundle\Filesystem\MountManager;
use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Ferienpass\AdminBundle\Controller\Page\FilesController;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveListener;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\LiveComponent\Metadata\UrlMapping;
use Symfony\UX\TwigComponent\Attribute\ExposeInTemplate;

#[AsLiveComponent(route: 'live_component_admin')]
class Files extends AbstractController
{
    use DefaultActionTrait;

    #[LiveProp]
    public string $storage;

    #[LiveProp]
    public ?string $path = null;

    #[LiveProp(url: new UrlMapping(as: 'd'))]
    public ?string $selected = null;

    public function __construct(#[Autowire(service: 'contao.filesystem.mount_manager')] private readonly MountManager $mountManager)
    {
    }

    public static function getSubscribedServices(): array
    {
        $services = parent::getSubscribedServices();

        foreach (FilesController::STORAGES as $storage) {
            $services["contao.filesystem.virtual.$storage"] = VirtualFilesystemInterface::class;
        }

        return $services;
    }

    #[ExposeInTemplate]
    public function contents(): FilesystemItemIterator
    {
        return $this->getFilesystem()->listContents((string) $this->path);
    }

    #[ExposeInTemplate]
    public function current(): ?FilesystemItem
    {
        return $this->getFilesystem()->get((string) $this->selected);
    }

    #[LiveListener('selected')]
    public function onFileSelected(#[LiveArg] ?string $path): void
    {
        $this->selected = $path;
    }

    #[LiveAction]
    public function delete(#[LiveArg] string $path): void
    {
        $this->getFilesystem()->delete($path);
    }

    private function getFilesystem(): VirtualFilesystemInterface
    {
        /** @noinspection MissingService */
        return $this->container->get("contao.filesystem.virtual.$this->storage");
    }
}
