<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components\Edit;

use Ferienpass\AdminBundle\Form\EditParticipantType;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;

#[AsLiveComponent(template: '@FerienpassAdmin/components/Edit.html.twig', route: 'live_component_admin')]
class Participant extends EditForm
{
    use ComponentWithFormTrait;

    #[LiveProp]
    public ParticipantInterface $item;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(EditParticipantType::class, $this->item, $this->formOptions);
    }
}
