<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components\Edit;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\AdminBundle\Form\EditOfferCategoriesType;
use Ferienpass\CoreBundle\Entity\OfferCategory;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;

#[AsLiveComponent(template: '@FerienpassAdmin/components/Edit.html.twig', route: 'live_component_admin')]
class OfferCategories extends EditForm
{
    use ComponentWithFormTrait;

    public function __construct(private readonly EntityManagerInterface $entityManager)
    {
    }

    protected function instantiateForm(): FormInterface
    {
        $categories = $this->entityManager->getRepository(OfferCategory::class)->findAll();

        return $this->createForm(EditOfferCategoriesType::class, ['categories' => $categories]);
    }
}
