<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components\Edit;

use Ferienpass\AdminBundle\Form\EditOfferType;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;

#[AsLiveComponent(template: '@FerienpassAdmin/components/Edit.html.twig', route: 'live_component_admin')]
class Offer extends EditForm
{
    use ComponentWithFormTrait;

    #[LiveProp]
    public OfferInterface $item;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(EditOfferType::class, $this->item, $this->formOptions);
    }
}
