<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\Components;

use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent]
class ButtonWithDropdown
{
    #[LiveProp]
    public ?string $href = null;
    #[LiveProp]
    public bool $modal = false;
    #[LiveProp]
    public ?string $buttonText = null;

    #[LiveProp]
    public string $position = 'right';
}
