<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\ApplicationSystem;

use Doctrine\ORM\EntityManagerInterface;
use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\Workflow\WorkflowInterface;

class ParticipantListFacade
{
    public function __construct(private readonly EntityManagerInterface $entityManager, private readonly WorkflowInterface $attendanceStateMachine)
    {
    }

    /**
     * @param Attendance[] $attendances
     */
    public function confirm(array $attendances, bool $notify = true): void
    {
        foreach ($attendances as $attendance) {
            if (null === $attendance->getParticipant()) {
                continue;
            }

            if (!$this->attendanceStateMachine->can($attendance, Attendance::TRANSITION_CONFIRM)) {
                continue;
            }

            $this->attendanceStateMachine->apply($attendance, Attendance::TRANSITION_CONFIRM, ['notify' => $notify, 'reorder' => false]);
        }

        $this->entityManager->flush();
    }

    /**
     * @param Attendance[] $attendances
     */
    public function reject(array $attendances, bool $notify = true): void
    {
        foreach ($attendances as $attendance) {
            if (null === $attendance->getParticipant()) {
                continue;
            }

            if (!$this->attendanceStateMachine->can($attendance, Attendance::TRANSITION_REJECT)) {
                continue;
            }

            $this->attendanceStateMachine->apply($attendance, Attendance::TRANSITION_REJECT, ['notify' => $notify, 'reorder' => false]);
        }

        $this->entityManager->flush();
    }
}
