<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\AdminBundle\ApplicationSystem;

use Ferienpass\AdminBundle\Event\ParticipantListEvent;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

class ParticipantListDto
{
    public function __construct(private readonly EventDispatcherInterface $dispatcher)
    {
    }

    /**
     * @return array<string, string> where key is the table column and value is a twig equivalent of the cell value
     */
    public function adminViewColumns(OfferInterface $offer): array
    {
        $columns = [
            // language=twig
            'name' => '{{ item.participant ? item.participant.name : "Gelöschter Teillnehmer" }}',
            // language=twig
            'age' => '
{% if not item.offer or not item.offer.dates|first %}
    {{ item.participant ? item.participant.age : "-" }}
{% else %}
    {{ item.participant ? item.participant.age(item.offer.dates|first.begin) : "-" }}
{% endif %}',
            // language=twig
            'email' => '{{ item.participant ? item.participant.email : "-" }}',
            // language=twig
            'mobile' => '{{ item.participant ? item.participant.mobile : "-" }}',
            // language=twig
            'phone' => '{{ item.participant ? item.participant.phone : "-" }}',
            // language=twig
            'status' => '
{% import "@FerienpassAdmin/components/content_elements.html.twig" as partials %}
{{ partials.status_badge(item.status, "sm", "-ml-2") }}',
        ];

        $event = new ParticipantListEvent($offer, $columns);
        $this->dispatcher->dispatch($event);

        return $event->getColumns();
    }
}
