<?php

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Ferienpass\AdminBundle\Controller\Dashboard\GanttController;
use Ferienpass\AdminBundle\Controller\Dashboard\HeatmapController;
use Ferienpass\AdminBundle\Controller\Dashboard\NextStepsController;
use Ferienpass\AdminBundle\Form\Filter\AccountsFilter;
use Ferienpass\AdminBundle\Form\Filter\AttendancesFilter;
use Ferienpass\AdminBundle\Form\Filter\ConsentsFilter;
use Ferienpass\AdminBundle\Form\Filter\HostsFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\EditionFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\HidePastFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\HostFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\OnlineApplicationFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\RequiresAgreementLetterFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\RequiresApplicationFilter;
use Ferienpass\AdminBundle\Form\Filter\Offer\StatusFilter;
use Ferienpass\AdminBundle\Form\Filter\OffersFilter;
use Ferienpass\AdminBundle\Form\Filter\ParticipantFilter;
use Ferienpass\AdminBundle\Form\Filter\Payment\UserFilter;
use Ferienpass\AdminBundle\Form\Filter\PaymentsFilter;
use Ferienpass\AdminBundle\Menu\ActionsBuilder;
use Ferienpass\AdminBundle\Menu\MenuBuilder;
use Knp\Menu\Twig\Helper;
use Twig\Extension\StringLoaderExtension;

return function(ContainerConfigurator $container): void {
    $services = $container->services()
        ->defaults()
        ->autoconfigure()
        ->autowire()
    ;

    $services
        ->load('Ferienpass\\AdminBundle\\', '../src/')
        ->exclude(['../src/{DependencyInjection,Entity}', '../src/LiveComponent/MultiSelect.php'])
    ;

    $services->get(NextStepsController::class)->tag('ferienpass_admin.dashboard_widget', ['priority' => 1000]);
    $services->get(HeatmapController::class)->tag('ferienpass_admin.dashboard_widget', ['priority' => 100]);
    $services->get(GanttController::class)->tag('ferienpass_admin.dashboard_widget', ['priority' => 10]);

    // Tags by directory
    $services
        ->load('Ferienpass\\AdminBundle\\Controller\\Statistics\\', '../src/Controller/Statistics/')
        ->tag('ferienpass_admin.stats_widget')
    ;

    // Tags autoconfigure
    $services
        ->get(OffersFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(PaymentsFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(ParticipantFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(ConsentsFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(AccountsFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(AttendancesFilter::class)
        ->tag('ferienpass_admin.filter')
    ;
    $services
        ->get(HostsFilter::class)
        ->tag('ferienpass_admin.filter')
    ;

    $services
        ->get(EditionFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'edition', 'priority' => 90])
    ;
    $services
        ->get(HostFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'host', 'priority' => 90])
    ;
    $services
        ->get(HidePastFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'hidePast', 'priority' => 90])
    ;
    $services
        ->get(OnlineApplicationFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'onlineApplication', 'priority' => 70])
    ;
    $services
        ->get(RequiresApplicationFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'requiresApplication', 'priority' => 80])
    ;
    $services
        ->get(RequiresAgreementLetterFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'requiresAgreementLetter', 'priority' => 70])
    ;
    $services
        ->get(StatusFilter::class)
        ->tag('ferienpass_admin.filter.offer', ['key' => 'status', 'priority' => 60])
    ;

    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Account\EditionFilter::class)
        ->tag('ferienpass_admin.filter.account', ['key' => 'edition'])
    ;

    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Host\EditionFilter::class)
        ->tag('ferienpass_admin.filter.host', ['key' => 'edition'])
    ;

    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Participant\EditionFilter::class)
        ->tag('ferienpass_admin.filter.participant', ['key' => 'edition'])
    ;
    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Participant\UnpaidFilter::class)
        ->tag('ferienpass_admin.filter.participant', ['key' => 'unpaid'])
    ;

    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Payment\EditionFilter::class)
        ->tag('ferienpass_admin.filter.payment', ['key' => 'edition'])
    ;
    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Attendance\EditionFilter::class)
        ->tag('ferienpass_admin.filter.attendance', ['key' => 'edition'])
    ;
    $services
        ->get(\Ferienpass\AdminBundle\Form\Filter\Payment\StatusFilter::class)
        ->tag('ferienpass_admin.filter.payment', ['key' => 'status'])
    ;
    $services
        ->get(UserFilter::class)
        ->tag('ferienpass_admin.filter.payment', ['key' => 'user'])
    ;

    // Aliases for autowiring
    $services->alias(Helper::class, 'knp_menu.helper');

    $services->get(MenuBuilder::class)
        ->tag('knp_menu.menu_builder', ['method' => 'primaryNavigation', 'alias' => 'admin_primary'])
        ->tag('knp_menu.menu_builder', ['method' => 'userNavigation', 'alias' => 'host_user_navigation'])
        ->tag('knp_menu.menu_builder', ['method' => 'offerActions', 'alias' => 'host_offer_actions'])
        ->tag('knp_menu.menu_builder', ['method' => 'offerFilters', 'alias' => 'host_offer_filters'])
        ->tag('knp_menu.menu_builder', ['method' => 'participantListActions', 'alias' => 'host_participant_list_actions'])
    ;

    $services->get(ActionsBuilder::class)
        ->tag('knp_menu.menu_builder', ['method' => 'actions', 'alias' => 'admin_list_actions'])
    ;

    $services->set(StringLoaderExtension::class);
};
