"use strict";

import {Controller} from "@hotwired/stimulus";

export default class extends Controller {
  static targets = ["tab", "button"];

  static values = {
    selected: String,
  };

  static classes = ["current", "default"];

  connect() {
    this.tabTargets[0].classList.remove("hidden");
    this.buttonTargets[0].classList.add(...this.currentClasses);
    for (const t of this.buttonTargets.slice(1)) {
      t.classList.add(...this.defaultClasses);
    }
  }

  select({ params }) {
    this.tabTargets.map((x) => {
      if (x.dataset.tab === params.tab) {
        x.classList.remove("hidden");
        this.selectedValue = params.tab;
      } else {
        x.classList.add("hidden");
      }
    });

    this.buttonTargets.map((x) => {
      if (x.dataset["ferienpass-AdminTabsTabParam"] === params.tab) {
        x.classList.add(...this.currentClasses);
        x.classList.remove(...this.defaultClasses);
      } else {
        x.classList.remove(...this.currentClasses);
        x.classList.add(...this.defaultClasses);
      }
    });
  }
}
