"use strict";

import {Controller} from "@hotwired/stimulus";
// @ts-ignore
import {useClickOutside} from "stimulus-use";

export default class extends Controller {
  static targets = ["dialog", "title", "dynamicContent"];

  connect() {
    this.observer = null;

    if (this.hasDynamicContentTarget) {
      this.observer = new MutationObserver(() => {
        const shouldOpen =
          this.dynamicContentTarget.innerHTML.trim().length > 0;
        if (shouldOpen && !this.dialogTarget.open) {
          this.show();
        } else if (!shouldOpen && this.dialogTarget.open) {
          this.hide();
        }
      });
      this.observer.observe(this.dynamicContentTarget, {
        childList: true,
        characterData: true,
        subtree: true,
      });
    }

    useClickOutside(this);
  }

  disconnect() {
    if (this.observer) {
      this.observer.disconnect();
    }
    if (this.dialogTarget.open) {
      this.hide();
    }
  }

  clickOutside() {
    this.hide();
  }

  show() {
    this.dialogTarget.showModal();
    document.body.classList.add("overflow-hidden");

    this.titleTarget.innerText =
      this.dynamicContentTarget.querySelector("h2")?.innerText ?? "";
    // enter(this.dialogTarget)
  }

  hide() {
    document.body.classList.remove("overflow-hidden");
    this.dialogTarget.close();

    // leave(this.dialogTarget)
  }
}
