"use strict";

import {Controller} from "@hotwired/stimulus";
import Sortable from "sortablejs";
// @ts-ignore
import {getComponent} from "@symfony/ux-live-component";

export default class extends Controller {
  static values = {
    count: Number,
  };

  static targets = [
    "confirmedColumn",
    "waitlistedColumn",
    "waitingColumn",
    "withdrawnColumn",
  ];

  async initialize() {
    this.component = await getComponent(this.element);
    const component = this.component;
    if (typeof component === "undefined") {
      throw new Error("Count value is undefined");
    }

    [
      this.confirmedColumnTarget,
      this.waitlistedColumnTarget,
      this.waitingColumnTarget,
      this.withdrawnColumnTarget,
    ].forEach((column) => {
      if (!(column instanceof HTMLElement)) {
        return;
      }

      const list = column.querySelector("ul[data-attendance-status]");
      if (!(list instanceof HTMLElement)) {
        return;
      }

      Sortable.create(list, {
        group: "assign",
        ghostClass: "bg-yellow-50",
        onChoose: function (event) {
          component.emit("selectParticipant", {
            participant: event.item.dataset.participantId,
          });
        },
        onAdd: (event) =>
          component.emit("statusChanged", {
            attendance: event.item.dataset.attendanceId, // event.items for multi-drag plugin (empty array for one item)
            newStatus: event.to.dataset.attendanceStatus,
            newIndex: event.newIndex,
          }),
        onUpdate: (event) =>
          component.emit("indexUpdated", {
            attendance: event.item.dataset.attendanceId,
            newIndex: event.newIndex,
          }),
        onSort: () =>
          (this.countValue = column.querySelectorAll("ul > li").length),
      });
    });
  }
}
