import {Controller} from "@hotwired/stimulus";
import EasyMDE from "easymde";

export default class extends Controller {
  static values = {
    options: { type: Object, default: {} },
  };

  connect() {
    // Initialize EasyMDE on the connected textarea
    const baseOptions = {
      element: this.element,
      spellChecker: false,
      autofocus: false,
      status: false,
      indentWithTabs: false,
    };

    const options = Object.assign({}, baseOptions, this.optionsValue || {});
    this.editor = new EasyMDE(options);
  }

  disconnect() {
    if (this.editor && typeof this.editor.toTextArea === "function") {
      this.editor.toTextArea();
    }
    this.editor = null;
  }
}
