"use strict";

import { Controller } from "@hotwired/stimulus";
// @ts-ignore
import { enter, leave } from "el-transition";

export default class extends Controller {
  static targets = ["item"];

  open() {
    this.itemTarget.classList.remove("hidden");
    enter(this.itemTarget);
  }

  close() {
    Promise.all([leave(this.itemTarget)]).then(() => {
      this.itemTarget.classList.add("hidden");
    });
  }

  toggle() {
    this.itemTarget.classList.contains("hidden") ? this.open() : this.close();
  }
}
