"use strict";

import { Controller } from "@hotwired/stimulus";
// @ts-ignore
import { enter, leave } from "el-transition";

export default class extends Controller {
  static targets = ["dialog", "dynamicContent"];
  static values = { open: Boolean };

  connect() {
    this.observer = null;

    if (this.hasDynamicContentTarget) {
      this.observer = new MutationObserver(() => {
        const shouldOpen =
          this.dynamicContentTarget.innerHTML.trim().length > 0;
        if (shouldOpen && !this.dialogTarget.open) {
          this.show();
        } else if (!shouldOpen && this.dialogTarget.open) {
          this.hide();
        }
      });
      this.observer.observe(this.dynamicContentTarget, {
        childList: true,
        characterData: true,
        subtree: true,
      });
    }

    if (this.openValue) {
      this.show();
    }
  }

  openValueChanged() {
    if (this.openValue) {
      this.show();
    } else {
      this.hide();
    }
  }

  disconnect() {
    if (this.observer) {
      this.observer.disconnect();
    }
    if (this.dialogTarget.open) {
      this.hide();
    }
  }

  show() {
    this.dialogTarget.showModal();
    document.body.classList.add("overflow-hidden");
    enter(this.dialogTarget);

    this.openValue = true;
  }

  hide() {
    document.body.classList.remove("overflow-hidden");
    this.dialogTarget.close();

    leave(this.dialogTarget);

    this.openValue = false;
  }
}
