"use strict";

import { Controller } from "@hotwired/stimulus";
import { getComponent } from "@symfony/ux-live-component";

export default class extends Controller {
  static targets = [];
  static values = {
    isChanged: Boolean,
  };

  async initialize() {
    this.component = await getComponent(this.element);
  }

  formIsChanged() {
    this.isChangedValue = true;
  }

  isFormChanged() {
    return this.isChangedValue;
  }

  leavingPage(event) {
    if (this.isFormChanged()) {
      if (
        !window.confirm(
          "Sie haben Ihre Änderungen nicht gespeichert. Klicken Sie »Abbrechen«, wenn Sie Ihre Änderungen noch speichern wollen oder klicken Sie »OK«, wenn Sie Ihre Änderungen nicht speichern wollen.",
        )
      ) {
        event.preventDefault();
      }

      // TODO, show custom form for the turbo event
      // if (event.type == "turbolinks:before-visit") {
      //     // open modal
      // } else {
      //     // browser default
      //  }
    }
  }
}
