"use strict";

import { Controller } from "@hotwired/stimulus";
import * as Gantt from "frappe-gantt";

export default class extends Controller {
  static values = {
    tasks: Array,
  };

  static targets = ["gantt"];

  connect() {
    const tasks = this.tasksValue;

    new Gantt.default(this.ganttTarget, tasks, {
      view_mode: "Month",
      bar_height: 14,
      //step: 12,
      //column_width: 10,
      padding: 14,
      language: "de",
      bar_corner_radius: 2,
      // @ts-ignore
      popup: (task) => `
<div>
<h5 class="text-white text-sm font-medium whitespace-nowrap">${task.name}
<a class="text-white font-normal text-xs underline" href="${task.editLink}" title="${task.editTitle}">bearbeiten</a>
</h5>
<p class="mt-1 text-gray-100 leading-4 text-sm">${task.description}</p>
</div>
`,
    });
  }
}
